; Tern (Terrain)                                     :
; a 63-byte intro by rrrola <rrrola@gmail.com>       :tt    NN
; greets to everyone who likes hiking         .    :tttttt  NN
;....       .                               ..:.t::tttteeE  NN
;tttt:..:..:..::                        . .t:tttteeRRtteeEE NNtee
;eRttteetReRRtttt: . .               . .:.:teRReRRRRRREENENNNNRee
;RReeRReRRRRRettttttttt..            ..teteeeRRRRRREEEENNENNNNNNN
;EEERRRRRRRRRRRetttttetttttt .   :  .:teeeRRRRRREEEEEENNNNNNNNNNN
;ENERERRERRRRRRReeeeeeeettttttt:tttt.ttRRRRERRREEEEENNNNNNNNNNNNN
;NNEEEEEEREERRRRRRRReReeeeteetetettttteRRREEEEENEENNNNNNNNNNNNNNN

org 100h   ; assume ds<=0x249f ah=0 si=0x100

;68 f6 9f
  push 0xa000 - 160/16
;34 13
T xor al,13h
;cd 10
  int 0x10      ; set 320x200 mode
;c5 2c
  lds bp,[si]   ; ds=0x349f: texture segment
;07             ; bp=0xf668, cx=0x00ff: deterministic texture seed
  pop es        ; es=0x9ff6: centered screen segment

;Generate a row (256 texels) of terrain: use cx,bp
;- inspired by baze's texture generator from Tube, Lattice, Lander
                  ; ch = left texel [si+124]
;13 cd  adc cx,bp ; ch += random (-16..16)
;10 c5  adc ch,al ; ch += top right texel [si-1]
;2c 07  sub al,7  ; harmless
  lodsb           ; load top right texel [si], advance si (= time)
  shr cx,1        ; average ch to 0..127; cl,carry = old texel bits
  mov [si+125],ch ; store texel = (left + top right + random + adc) / 2
; mov [si+253],ch ;(+1 byte: slowly varying terrain)
  rcl bp,cl       ; next random value
  sar bp,3        ; adjust it to (-16..16), mess up the top bits
  inc ah          ; loop 256 times, si += 256
  jnz T+1

;Raymarch the terrain, compute the hit distance: don't touch cx,bp
;- mul/imul trick from HellMood's Gespensterwald
R mov bh,7      ; bh=z (depth): 7..127 (7 prevents color underflow)
Z mov ax,0xcccd
  mul di        ; dh = unsigned y (0..200), dl = signed x (-128..128)
  mov al,dh
  mul bh        ; ah=y*z (unsigned because y can be > 127)
  xchg ax,dx    ; dh=y*z, al=x
  imul bh       ; ah=x*z (signed), al=fraction(x*z)
  mov bl,ah     ; bl=x*z
  cmp [bx+si],dh; hit if texture[x*z, z+time] <= y*z?
  jb D
  inc bh        ; no hit: z++
  jns Z

;Dithering, illusion of light from the right side
D aam 37        ; ah=al/37 ~~ 7*fraction(x*z)
  sub ah,bh     ; ah -= z_hit (128..255)
  shr ax,11     ; al=ah/8 (16..31: grayscale), ah=0

;Next pixel (65536 times)
  stosb
  test di,di
  jnz R

;Next frame
;  call SCREENSHOT
  jmp T+1      ; ah=0: loop 256 times; al = last pixel

;%include "screenshot.inc"
